--[[FMPM package metadata:
info = "Webdings support script"
location = "/boot/96_webdings.lua"
]]

local component = require "component"
local computer = require "computer"

local t = {
    ["!"] = "✀",
    ["\""] = "✁",
    ["#"] = "✂",
    ["$"] = "✃",
    ["%"] = "✄",
    ["&"] = "✅",
    ["'"] = "✆",
    ["("] = "✇",
    [")"] = "✈",
    ["*"] = "✉",
    ["+"] = "✺",
    [","] = "❂",
    ["-"] = "➛",
    ["."] = "➗",
    ["/"] = "✎",
    ["0"] = "✏",
    ["1"] = "✐",
    ["2"] = "✑",
    ["3"] = "✒",
    ["4"] = "✓",
    ["5"] = "✔",
    ["6"] = "✕",
    ["7"] = "✖",
    ["8"] = "✞",
    ["9"] = "✟",
    [":"] = "✠",
    [";"] = "✡",
    ["<"] = "✦",
    ["="] = "✧",
    [">"] = "✱",
    ["?"] = "✲",
    ["@"] = "✹",
    ["A"] = "✊",
    ["B"] = "✿",
    ["C"] = "❀",
    ["D"] = "❁",
    ["E"] = "✋",
    ["F"] = "❍",
    ["G"] = "❎",
    ["H"] = "❏",
    ["I"] = "❐",
    ["J"] = "❑",
    ["K"] = "❒",
    ["L"] = "❓",
    ["M"] = "❔",
    ["N"] = "❕",
    ["O"] = "❖",
    ["P"] = "❗",
    ["Q"] = "❛",
    ["R"] = "❜",
    ["S"] = "❝",
    ["T"] = "❞",
    ["U"] = "❟",
    ["V"] = "❠",
    ["W"] = "❡",
    ["X"] = "❢",
    ["Y"] = "❣",
    ["Z"] = "❤",
    ["["] = "❥",
    ["\\"] = "❦",
    ["]"] = "❧",
    ["^"] = "➔",
    ["_"] = "➕",
    ["`"] = "➖",
    ["a"] = "✍",
    ["b"] = "➘",
    ["c"] = "➙",
    ["d"] = "➚",
    ["e"] = "✌",
    ["f"] = "➜",
    ["g"] = "➝",
    ["h"] = "➞",
    ["i"] = "➟",
    ["j"] = "➠",
    ["k"] = "➡",
    ["l"] = "➢",
    ["m"] = "➣",
    ["n"] = "➤",
    ["o"] = "➥",
    ["p"] = "➦",
    ["q"] = "➧",
    ["r"] = "➨",
    ["s"] = "➩",
    ["t"] = "➪",
    ["u"] = "➫",
    ["v"] = "➬",
    ["w"] = "➭",
    ["x"] = "➮",
    ["y"] = "➯",
    ["z"] = "➰",
    ["{"] = "➿",
    ["|"] = "☀",
    ["}"] = "☁",
    ["~"] = "☂",
}

local oldset = component.gpu.set

component.gpu.set = function(x, y, str, ...)
    local newstr = ""
    for c in str:gmatch"." do
        if t[c] ~= nil then
            newstr = newstr .. t[c]
        else
            newstr = newstr .. c
        end
    end
    return oldset(x, y, newstr, ...)
end
