--[[FMPM package metadata:
info = "IP daemon!"
location = "/etc/rc.d/ip.lua"
]]

local component = require "component"
local event = require "event"
local serialization = require "serialization"
local ip = require "ip"

local config

local function onMessage(_, localAddress, remoteAddress, port, _, data, payload, ...)
    if type(data) ~= "string" then return end
    data = serialization.unserialize(data)
    if type(data) ~= "table" then return end
    
    if port ~= 65535 and data.type == "IP" then
        ip._handleModemMessage(port, data, payload, ...)
    else
        if data.type == "discover" then
            component.modem.send(remoteAddress, 65535,
                serialization.serialize{type="routes"},
                serialization.serialize{[config.hostname] = 0})
        elseif data.type == "IP" then
            payload = serialization.unserialize(payload)
            if type(payload) == "table" and payload.type == "ICMP" and payload.id == "ping" then
                component.modem.send(config.gateway, 65535,
                    serialization.serialize{type="IP", srcHost = data.destHost, destHost = data.srcHost, srcPort = data.destPort, destPort = data.srcPort, ttl=32},
                    serialization.serialize{type="ICMP", id="pong"},
                    ...)
            end
        end
    end
end

function start()
    local file = io.open("/etc/ip.conf")
    if file == nil then
        error("Missing ip config file. Use `ipconfig` command to configure interface.")
    end
    config = serialization.unserialize(file:read("*a"))
    file:close()
    component.modem.open(65535)
    event.listen("modem_message", onMessage)
end

function stop()
    component.modem.close(65535)
    event.ignore("modem_message", onMessage)
end
