--[[FMPM package metadata:
info = "Image viewer"
location = "/imgviewer.lua"
]]

local image = require("image")
local shell = require("shell")
local args, options = shell.parse(...)

if not args[1] then
	print("Usage: imgviewer <filename>")
	return
end

local img = image.loadFromFile(args[1])

--[[
print(args[1] .. " - " .. img:getType() .. " File")
print(img:getSize() .. " bytes")
print(img:getWidth() .. " x " .. img:getHeight())
print(img:getColorCount() .. " colors")
]]

if not args[2] and not args[3] then
	if options.f then
		img:drawFullscreen()
	else
		img:drawInline()
	end
else
	img:drawAt(tonumber(args[2]),tonumber(args[3]))
end