--[[FMPM package metadata:
info = "FumMaker's Package Manager back-end daemon for servers."
location = "/etc/rc.d/fmpm.lua"
components = {"internet", "modem"}
require = {"fmpm"}
]]

internet = require("internet")
filesystem = require("filesystem")
component = require("component")

local function loadConfig(config)
    local t = {}
    local f = load(config, "package config", "t", t)()
    return t
end

function list()
    error("Not implemented!")
end

function install(name)
    local response = component.internet.request("https://minecart.funmaker.moe/fmpm/" .. name .. ".lua")
    if response:response() == 404 then
        error("Package " .. file .. " not found")
    end

    local content = ""

    while true do
        local chunk = response.read()
        if chunk == nil then break end
        content = content .. chunk
    end

    local header = "--[[FMPM package metadata:"

    if content:sub(1, #header) ~= header or not content:find("]]") then
        error("This is not an fmpm package.")
    end

    local metadata = content:sub(#header + 1, content:find("]]") - 1)
    metadata = loadConfig(metadata)

    if not metadata.location then
        error("missing required `location` metadata.")
    end

    local file = io.open(metadata.location, "w")
    file:write(content)
    file:close()
end

function update()
    error("Not implemented!")
end

function uninstall()
    error("Not implemented!")
end

function upload(path)
    local name = filesystem.name(path)
    local file, error = io.open(path)
    if file == nil then
        error(error)
    end

    local data = file:read("*a")
    file:close()

    local request = {file = data,
                    filename = name,
                    key = "djbartek3838",
                    dir = "/fmpm/"}
    local response = internet.request("https://minecart.funmaker.moe/www/upload.php", request)

    for chunk in response do
        io.write(chunk)
    end
end

function start()

end

function stop()

end
