--[[FMPM package metadata:
info = "Plot Manager"
location = "/lib/boxdrawing.lua"
]]

local boxdrawing = {
  ["NNNN"] = " ",
  ["NSNS"] = "─",
  ["NBNB"] = "━",
  ["SNSN"] = "│",
  ["BNBN"] = "┃",
  ["NSSN"] = "┌",
  ["NBSN"] = "┍",
  ["NSBN"] = "┎",
  ["NBBN"] = "┏",
  ["NNSS"] = "┐",
  ["NNSB"] = "┑",
  ["NNBS"] = "┒",
  ["NNBB"] = "┓",
  ["SSNN"] = "└",
  ["SBNN"] = "┕",
  ["BSNN"] = "┖",
  ["BBNN"] = "┗",
  ["SNNS"] = "┘",
  ["SNNB"] = "┙",
  ["BNNS"] = "┚",
  ["BNNB"] = "┛",
  ["SSSN"] = "├",
  ["SBSN"] = "┝",
  ["BSSN"] = "┞",
  ["SSBN"] = "┟",
  ["BSBN"] = "┠",
  ["BBSN"] = "┡",
  ["SBBN"] = "┢",
  ["BBBN"] = "┣",
  ["SNSS"] = "┤",
  ["SNSB"] = "┥",
  ["BNSS"] = "┦",
  ["SNBS"] = "┧",
  ["BNBS"] = "┨",
  ["BNSB"] = "┩",
  ["SNBB"] = "┪",
  ["BNBB"] = "┫",
  ["NSSS"] = "┬",
  ["NSSB"] = "┭",
  ["NBSS"] = "┮",
  ["NBSB"] = "┯",
  ["NSBS"] = "┰",
  ["NSBB"] = "┱",
  ["NBBS"] = "┲",
  ["NBBB"] = "┳",
  ["SSNS"] = "┴",
  ["SSNB"] = "┵",
  ["SBNS"] = "┶",
  ["SBNB"] = "┷",
  ["BSNS"] = "┸",
  ["BSNB"] = "┹",
  ["BBNS"] = "┺",
  ["BBNB"] = "┻",
  ["SSSS"] = "┼",
  ["SSSB"] = "┽",
  ["SBSS"] = "┾",
  ["SBSB"] = "┿",
  ["BSSS"] = "╀",
  ["SSBS"] = "╁",
  ["BSBS"] = "╂",
  ["BSSB"] = "╃",
  ["BBSS"] = "╄",
  ["SSBB"] = "╅",
  ["SBBS"] = "╆",
  ["BBSB"] = "╇",
  ["SBBB"] = "╈",
  ["BSBB"] = "╉",
  ["BBBS"] = "╊",
  ["BBBB"] = "╋",
  ["NDND"] = "═",
  ["DNDN"] = "║",
  ["NDSN"] = "╒",
  ["NSDN"] = "╓",
  ["NDDN"] = "╔",
  ["NNSD"] = "╕",
  ["NNDS"] = "╖",
  ["NNDD"] = "╗",
  ["SDNN"] = "╘",
  ["DSNN"] = "╙",
  ["DDNN"] = "╚",
  ["SNND"] = "╛",
  ["DNNS"] = "╜",
  ["DNND"] = "╝",
  ["SDSN"] = "╞",
  ["DSDN"] = "╟",
  ["DDDN"] = "╠",
  ["SNSD"] = "╡",
  ["DNDS"] = "╢",
  ["DNDD"] = "╣",
  ["NDSD"] = "╤",
  ["NSDS"] = "╥",
  ["NDDD"] = "╦",
  ["SDND"] = "╧",
  ["DSNS"] = "╨",
  ["DDND"] = "╩",
  ["SDSD"] = "╪",
  ["DSDS"] = "╫",
  ["DDDD"] = "╬",
  ["NNNS"] = "╴",
  ["SNNN"] = "╵",
  ["NSNN"] = "╶",
  ["NNSN"] = "╷",
  ["NNNB"] = "╸",
  ["BNNN"] = "╹",
  ["NBNN"] = "╺",
  ["NNBN"] = "╻",
  ["NBNS"] = "╼",
  ["SNBN"] = "╽",
  ["NSNB"] = "╾",
  ["BNSN"] = "╿",
  ["NgNg"] = "╌",
  ["NGNG"] = "╍",
  ["gNgN"] = "╎",
  ["GNGN"] = "╏",
  ["NtNt"] = "┄",
  ["NTNT"] = "┅",
  ["tNtN"] = "┆",
  ["TNTN"] = "┇",
  ["NqNq"] = "┈",
  ["NQNQ"] = "┉",
  ["qNqN"] = "┊",
  ["QNQN"] = "┋",
}

boxdrawing.find = function(top, right, bottom, left)
  local type = (top or "N") .. (right or "N") .. (bottom or "N") .. (left or "N")
  if boxdrawing[type] == nil then
    type = type:gsub("[BgGtTqQ]", "S")
    if boxdrawing[type] == nil then
      type = type:gsub("D", "S")
      if boxdrawing[type] == nil then
        type = type:gsub("S", "N")
        if boxdrawing[type] == nil then
          error("Unknown boxdrawing type: " .. type)
        end
      end
    end
  end
  return boxdrawing[type];
end

return boxdrawing
