--[[FMPM package metadata:
info = "Plot Manager"
location = "/usr/bin/plotmgr.lua"
]]

local MAPX = 10
local MAPY = 10
local POSX = 400
local POSY = 804

local PLOTSIZE = 16

local selectX = 1
local selectY = 5

local component = require "component"
local colors = require "colors"
local bd = require "boxdrawing"
local gpu = component.gpu

local function renderMap()
  gpu.setBackground(0x001133)
  gpu.setForeground(0xaaaaaa)
  gpu.fill(1, 1, 100, 50, " ")

  local linesX = {}
  local linesY = {}

  linesX[0] = {}
  linesY[0] = {}

  for x = 1, MAPX + 1 do
    linesX[x] = {}
    linesY[x] = {}

    for y = 1, MAPY + 1 do
      if y > MAPY then
        linesX[x][y] = "N"
      elseif x == 1 or x == MAPX + 1 then
        linesY[x][y] = "D"
      elseif y == selectY and (x == selectX or x == selectX + 1) and y <= MAPY then
        linesY[x][y] = "T"
      else
        linesY[x][y] = "q"
      end

      if x > MAPX then
        linesX[x][y] = "N"
      elseif y == 1 or y == MAPY + 1 then
        linesX[x][y] = "D"
      elseif x == selectX and (y == selectY or y == selectY + 1) then
        linesX[x][y] = "T"
      else
        linesX[x][y] = "q"
      end
    end
  end

  local canvas = {}

  for y = 1, MAPY + 1 do
    canvas[y * 4 - 3] = ""
    if y <= MAPY then
      canvas[y * 4 - 2] = ""
      canvas[y * 4 - 1] = ""
      canvas[y * 4 - 0] = ""
    end
    for x = 1, MAPX + 1 do
      local corner = bd.find(linesY[x][y-1], linesX[x][y], linesY[x][y], linesX[x-1][y])
      local top    = bd.find(           "N", linesX[x][y],          "N",   linesX[x][y])
      local left   = bd.find(  linesY[x][y],          "N", linesY[x][y],            "N")
      local pad    = string.rep(" ", x <= MAPX and 7 or 0)
      canvas[y * 4 - 3] = canvas[y * 4 - 3] .. corner .. string.rep(top, x <= MAPX and 7 or 0)

      if y <= MAPY then
        canvas[y * 4 - 2] = canvas[y * 4 - 2] .. left .. pad
        canvas[y * 4 - 1] = canvas[y * 4 - 1] .. left .. pad
        canvas[y * 4 - 0] = canvas[y * 4 - 0] .. left .. pad
      end
    end
  end

  for i, line in ipairs(canvas) do
    gpu.set(1 + 9, i + 4, line)
  end
end

renderMap()
