--[[FMPM package metadata:
info = "IP configuration utility"
location = "/usr/bin/hosts.lua"
]]

local shell = require "shell"
local serialization = require "serialization"
local component = require "component"
local computer = require "computer"
local event = require "event"
local ip = require "ip"

local args, options = shell.parse(...)

if options.h or options.help then
    print("Usage:")
    print("\thosts\tDisplay known hosts and number of hops")
    return
end

local config = ip.getConfig()

component.modem.send(config.gateway, 65535, serialization.serialize{type="discover"})
local timeout = computer.uptime() + 1
local candidates = {}
while computer.uptime() < timeout do
    local name, localAddress, remoteAddress, port, dist, headers, payload = event.pull(timeout - computer.uptime(), "modem_message")
    if port == 65535 and type(headers) == "string" and type(payload) == "string" then
        headers = serialization.unserialize(headers)
        payload = serialization.unserialize(payload)
        if type(headers) == "table" and type(payload) == "table" and headers.type == "routes" then
            for host, hops in pairs(payload) do
                if host == config.hostname then
                    table.insert(candidates, {host, 0})
                else
                    table.insert(candidates, {host, hops + 1})
                end
            end
            break
        end
    end
end

table.sort(candidates, function(a,b) return a[2]<b[2] end)

print("Hops\tHostname\n")

local foreground = component.gpu.getForeground()

for _, v in pairs(candidates) do
    component.gpu.setForeground(0xFFFFFF)
    io.write(v[2] .. "\t")
    if v[1]:find("router") then
        component.gpu.setForeground(0x777777)
    end
    print(v[1])
end

component.gpu.setForeground(foreground)
